<?php
/* --------------------------------------------------------------
  ConfigDeleter.inc.php 2019-06-07
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/

namespace StyleEdit\Repositories;

use \StyleEdit\Entities\StoredConfig;
use \StyleEdit\ConfigSettings;

/**
 * Class ConfigDeleter
 *
 * @package StyleEdit\Repositories
 */
class ConfigDeleter
{
	/** @var ConfigSettings $settings */
	private $settings;
	
	
	/**
	 * ConfigDeleter constructor.
	 *
	 * @param \StyleEdit\ConfigSettings $settings
	 */
	public function __construct(ConfigSettings $settings)
	{
		$this->settings = $settings;
	}
	
	
	/**
	 * Deletes a stored style edit config file.
	 *
	 * @param \StyleEdit\Entities\StoredConfig $styleConfig
	 * @param bool                             $p_fromOriginalTheme Delete files from original theme directory.
	 *
	 * @throws \RuntimeException if the given style is active
	 * @throws \RuntimeException if the file could not be deleted
	 *
	 * @return bool
	 */
	public function delete(StoredConfig $styleConfig, $p_fromOriginalTheme = false)
	{
		if($styleConfig->isActive())
		{
			throw new \RuntimeException('You can not delete the active Style. You must activate another Style before deleting this one.');
		}
		
		$filepath = $this->settings->getStylesDirectory($p_fromOriginalTheme) . $styleConfig->getFilename();
		
		if(!file_exists($filepath))
		{
			return true;
		}
		
		try
		{
			return unlink($filepath);
		}
		catch(\Exception $e)
		{
			throw new \RuntimeException('The file "' . $filepath . '" could not be deleted"');
		}
	}
}